(* Content-type: application/mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 6.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       145,          7]
NotebookDataLength[     27051,        794]
NotebookOptionsPosition[     24470,        715]
NotebookOutlinePosition[     25046,        735]
CellTagsIndexPosition[     25003,        732]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Baker-Schmidt camera with spherical mirrors", "Title"],

Cell[CellGroupData[{

Cell["Main function", "Subsection"],

Cell[TextData[StyleBox["BakerSchmidtCameraSM",
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Input variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["f1",
           FontWeight->Bold], Cell["focal length of the primary mirror"]},
         {Cell["\[Beta]",
           FontWeight->Bold], Cell["\<\
where \[Beta] = 1 \[Dash] \[Alpha] and \[Alpha] is the obstruction factor \
(under condition \[Alpha] \[GreaterEqual] 0.40)\
\>"]},
         {Cell["diam",
           FontWeight->Bold], Cell["diameter of the primary mirror"]},
         {Cell["\[Theta]",
           FontWeight->Bold], Cell["field angle in degrees"]},
         {Cell["sf",
           FontWeight->Bold], Cell["residual spherical aberration"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["Report"], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["Print"], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["Basic"], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["Values"], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["Full"], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["Minimal"], Cell[
          "gives only output values"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]],

Cell[CellGroupData[{

Cell["Interface function", "Subsection"],

Cell[TextData[{
 StyleBox["BakerSchmidtCameraSMInputPanel",
  FontWeight->"Bold",
  FontVariations->{"Underline"->True}],
 " (no argument required, it creates a panel to work with the main function \
by means of easy controls and input fields)"
}], "Text"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Auxiliary function", "Subsection"],

Cell[TextData[StyleBox["TotalAberrations",
 FontWeight->"Bold",
 FontVariations->{"Underline"->True}]], "Text"],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Input variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["rad",
           FontWeight->Bold], Cell["list of the radii of the surfaces"]},
         {Cell["thick",
           FontWeight->Bold], Cell["\<\
list of the distances between the surfaces along the optical axis\
\>"]},
         {Cell["ind",
           FontWeight->Bold], Cell["list of the refractive indices"]},
         {Cell["costasf",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"list of the constants which characterize the nature of any \
surface\"\>"},
             {"\<\"(0 for a sphere, K for a conic, {a4, as} for an aspheric \
surface)\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["stoprad",
           FontWeight->Bold], Cell["radius of the aperture stop"]},
         {Cell["nstop",
           FontWeight->Bold], Cell["number of the surfaces before the stop"]},
         {Cell["dis",
           FontWeight->Bold], 
          TagBox[GridBox[{
             {"\<\"if nstop = 0, is the (negative) distance of the aperture \
stop from the first surface after it\"\>"},
             {"\<\"if nstop > 0,  is the distance between the last surface \
before the aperture stop and the aperture stop\"\>"}
            },
            DefaultBaseStyle->"Column",
            GridBoxAlignment->{"Columns" -> {{Left}}},
            
            GridBoxItemSize->{
             "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
           "Column"]},
         {Cell["dobject",
           FontWeight->Bold], Cell[
          "distance of the object from the first surface"]},
         {Cell["hobject",
           FontWeight->Bold], Cell["\<\
height of the object (only if the object is at a finite distance)\
\>"]},
         {Cell["angle",
           FontWeight->Bold], Cell[
          "view angle in degrees (if the object is at infinity)"]},
         {Cell["waves",
           FontWeight->Bold], Cell[
          "the wavelengths of the chosen refractive indices"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Optional arguments\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["OutputType", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], "\[SpanFromLeft]"},
         {"\[SpanFromAbove]", Cell["Report"], Cell["\<\
generates a report as a new notebook, that can be saved in many formats, for \
instance PDF\
\>"]},
         {"\[SpanFromAbove]", Cell["Print"], Cell["\<\
prints results in the current position of the evaluating notebook\
\>"]},
         {"\[SpanFromAbove]", Cell["Basic"], Cell["\<\
returns the list of pairs, with the short description of the output and the \
corresponding value\
\>"]},
         {"\[SpanFromAbove]", Cell["Values"], Cell[
          "returns only the list of output values, no descriptions"]},
         {Cell["OutputLevel", "Georgia",
           FontSize->18,
           FontWeight->Bold], Cell["Possible values:"], Cell[""]},
         {"\[SpanFromAbove]", Cell["Full"], Cell[
          "gives both input parameters and output values"]},
         {"\[SpanFromAbove]", Cell["Minimal"], Cell[
          "gives only output values"]},
         {"\[SpanFromAbove]", Cell["Coefficients"], Cell[
          "gives only aberration coefficients"]},
         {"\[SpanFromAbove]", Cell["None"], Cell["doesn't show any result"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True],

Cell[BoxData[
 PanelBox[
  TagBox[GridBox[{
     {
      StyleBox["\<\"Output variables\"\>", "Georgia",
       StripOnInput->False,
       FontSize->18,
       FontWeight->Bold]},
     {
      TagBox[GridBox[{
         {Cell["GOn",
           FontWeight->Bold], Cell["Number of surface"]},
         {Cell["GOren",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the entrance pupil for \"",SubscriptBox[
            "\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOwen",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Distance of the exit pupil from the last surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOrexit",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Radius of the exit pupil for \"",SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOdistancefp",
           FontWeight->Bold], Cell[
          "Distance of the first principal plane from the first surface"]},
         {Cell["GOdistancesp",
           FontWeight->Bold], Cell[
          "Distance of the second principal plane from the last surface"]},
         {Cell["GOdistancegauss",
           FontWeight->Bold], 
          
          TemplateBox[{
           "\"Gaussian distance of the images from the surface for \"",
            SubscriptBox["\[Lambda]", "1"]},
           "RowDefault"]},
         {Cell["GOfocalLength",
           FontWeight->Bold], Cell["Focal length"]},
         {Cell["GOimageHeight",
           FontWeight->Bold], Cell["Image height"]},
         {Cell["GOaberration",
           FontWeight->Bold], Cell["Third-order spherical aberration "]},
         {Cell["GOcoma",
           FontWeight->Bold], Cell["Third-order coma"]},
         {Cell["GOastigmatism",
           FontWeight->Bold], Cell["Third-order astigmatism"]},
         {Cell["GOcurvature",
           FontWeight->Bold], Cell["Third-order total curvature"]},
         {Cell["GOSeidelCurvature",
           FontWeight->Bold], Cell["Third-order curvature coefficient"]},
         {Cell["GOPetzvalRadius",
           FontWeight->Bold], Cell["Petzval radius"]},
         {Cell["GOdistortion",
           FontWeight->Bold], Cell["Third-order distortion"]},
         {Cell["GOSphericalCoefficient",
           FontWeight->Bold], Cell["Spherical Coefficient"]},
         {Cell["GOComaCoefficient",
           FontWeight->Bold], Cell["Coma Coefficient"]},
         {Cell["GOAstigmatismCoefficient",
           FontWeight->Bold], Cell["Astigmatism Coefficient"]}
        },
        AutoDelete->False,
        BaseStyle->{FontSize -> 16, FontFamily -> "Georgia"},
        FrameStyle->RGBColor[1, 0.5, 0],
        GridBoxAlignment->{"Columns" -> {{Left}}, "Rows" -> {{Center}}},
        GridBoxDividers->{
         "Columns" -> {False, {True}, False}, 
          "Rows" -> {False, {True}, False}},
        GridBoxFrame->{"Columns" -> {{True}}, "Rows" -> {{True}}},
        GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}},
        GridBoxSpacings->{"Columns" -> {{2}}, "Rows" -> {{1.5}}}],
       "TextGrid"]}
    },
    DefaultBaseStyle->"Column",
    GridBoxAlignment->{"Columns" -> {{Center}}},
    GridBoxItemSize->{"Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}],
   "Column"],
  Background->GrayLevel[0.85]]], "Text",
 Deployed->True,
 GeneratedCell->True,
 CellAutoOverwrite->True]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["\<\
A third-order analysis of the Baker-Schmidt camera with spherical mirrors\
\>", "Title"],

Cell["\<\
Using TotalAberration auxiliary function you may calculate symbolic and/or \
numerical intermediate variable, so to explore the Baker-Schmidt camera \
project\[CloseCurlyQuote]s parameter. Here is an example of a third-order \
analysis.\
\>", "Text"],

Cell["\<\
We start with an optical system formed by two spherical mirrors. (the \
variables f1, \[Beta], \[Gamma], r, x, \[Theta], \[Lambda]1, \[Lambda]2, \
\[Lambda]3 have to be unassigned, for that we use Clear)\
\>", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"Clear", "[", 
   RowBox[{
   "f1", ",", " ", "\[Beta]", ",", " ", "\[Gamma]", ",", " ", "r", ",", " ", 
    "x", ",", " ", "\[Theta]", ",", " ", "\[Lambda]1", ",", " ", "\[Lambda]2",
     ",", " ", "\[Lambda]3"}], "]"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"rad", "=", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{
       RowBox[{"-", "2"}], "f1"}], ",", 
      RowBox[{
       RowBox[{"-", "\[Gamma]"}], " ", "f1"}]}], "}"}]}], ";"}], " "}], "\n", 
 RowBox[{
  RowBox[{"thick", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"-", "\[Beta]"}], " ", "f1"}], "}"}]}], ";"}], "\n", 
 RowBox[{
  RowBox[{"ind", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1", ",", 
       RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"costasf", "=", 
   RowBox[{"{", 
    RowBox[{"0", ",", "0"}], "}"}]}], ";"}], "\n", 
 RowBox[{"TotalAberrations", "[", 
  RowBox[{
  "rad", ",", "thick", ",", "ind", ",", "costasf", ",", "r", ",", "0", ",", 
   RowBox[{
    RowBox[{"-", "\[Delta]"}], " ", "f1"}], ",", 
   RowBox[{"-", "Infinity"}], ",", "x", ",", "\[Theta]", ",", 
   RowBox[{"{", 
    RowBox[{"\[Lambda]1", ",", "\[Lambda]2", ",", "\[Lambda]3"}], "}"}]}], 
  "]"}]}], "Input"],

Cell["The curvature vanishes if", "Text"],

Cell[BoxData[
 RowBox[{"eq3", "=", 
  RowBox[{
   RowBox[{"Numerator", "[", 
    RowBox[{"Together", "[", 
     StyleBox["GOSeidelCurvature",
      FontWeight->"Bold"], "]"}], "]"}], "//", "Factor"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"Solve", "[", 
   RowBox[{
    RowBox[{"eq3", "\[Equal]", "0"}], ",", "\[Gamma]"}], "]"}], "//", 
  "Flatten"}]], "Input"],

Cell["For \[Gamma] = 2  the other aberration coefficients become", "Text"],

Cell[BoxData[{
 RowBox[{"eq4", "=", 
  RowBox[{
   RowBox[{"Simplify", "[", "GOSphericalCoefficient", "]"}], "/.", 
   RowBox[{"\[Gamma]", "\[Rule]", "2"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"eq5", "=", 
  RowBox[{
   RowBox[{"Simplify", "[", "GOComaCoefficient", "]"}], "/.", 
   RowBox[{"\[Gamma]", "\[Rule]", "2"}]}]}], "\[IndentingNewLine]", 
 RowBox[{"eq6", "=", 
  RowBox[{
   RowBox[{"Simplify", "[", "GOAstigmatismCoefficient", "]"}], "/.", 
   RowBox[{"\[Gamma]", "\[Rule]", "2"}]}]}]}], "Input"],

Cell["Coma vanishes when", "Text"],

Cell[BoxData[
 RowBox[{"sco", "=", 
  RowBox[{
   RowBox[{"Solve", "[", 
    RowBox[{
     RowBox[{"eq5", "\[Equal]", "0"}], ",", "\[Delta]"}], "]"}], "//", 
   "Flatten"}]}]], "Input"],

Cell[BoxData[
 RowBox[{"Plot", "[", 
  RowBox[{
   RowBox[{"sco", "[", 
    RowBox[{"[", 
     RowBox[{"1", ",", "2"}], "]"}], "]"}], ",", 
   RowBox[{"{", 
    RowBox[{"\[Beta]", ",", "0.4", ",", "0.7"}], "}"}]}], "]"}]], "Input"],

Cell["The astigmatism coefficient is", "Text"],

Cell[BoxData[
 RowBox[{"Simplify", "[", 
  RowBox[{"eq6", "/.", "sco"}], "]"}]], "Input"],

Cell["The spherical aberration coefficient becomes", "Text"],

Cell[BoxData[
 RowBox[{"eq4b", "=", 
  RowBox[{"eq4", "/.", 
   RowBox[{"{", 
    RowBox[{"\[Delta]", "\[Rule]", 
     FractionBox[
      RowBox[{
       RowBox[{"-", "1"}], "-", 
       RowBox[{"3", " ", "\[Beta]"}], "+", 
       SuperscriptBox["\[Beta]", "2"], "+", 
       SuperscriptBox["\[Beta]", "3"]}], 
      RowBox[{"\[Beta]", " ", 
       RowBox[{"(", 
        RowBox[{
         RowBox[{"-", "2"}], "+", 
         SuperscriptBox["\[Beta]", "2"]}], ")"}]}]]}], "}"}]}]}]], "Input"],

Cell["and the spherical aberration coefficient vanishes if", "Text"],

Cell[BoxData[
 RowBox[{"Solve", "[", 
  RowBox[{
   RowBox[{
    RowBox[{
     RowBox[{"a4", 
      RowBox[{"(", 
       RowBox[{"GON", "-", "1"}], ")"}]}], "+", 
     FractionBox[
      RowBox[{
       RowBox[{
        RowBox[{"-", "16"}], " ", 
        SuperscriptBox["\[Beta]", "2"]}], "+", 
       RowBox[{"8", " ", 
        SuperscriptBox["\[Beta]", "4"]}]}], 
      RowBox[{"256", " ", 
       SuperscriptBox["f1", "3"]}]]}], "\[Equal]", "0"}], ",", "a4"}], 
  "]"}]], "Input"]
}, Open  ]],

Cell[CellGroupData[{

Cell["BakerSchmidtCameraSM Examples", "Title"],

Cell["\<\
To use the BakerSchmidtCameraCP function you can either use directly the \
function BakerSchmidtCameraSM[f1, \[Beta], diam, \[Theta], sf] or use the \
interactive panel created by calling the function \
BakerSchmidtCameraSMInputPanel[].
It let\[CloseCurlyQuote]s you to set input values and then call the \
BakerSchmidtCameraSM function. Moreover, it helps to load examples from the \
saved archives and set the output style.
Here are some examples\
\>", "Text"],

Cell["Baker-Schmidt camera with a primary F/2, \[Beta] = 0.45.", "Text",
 CellChangeTimes->{
  3.438609734609375*^9, {3.438609771140625*^9, 3.43860980246875*^9}, {
   3.43892822834375*^9, 3.438928236859375*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", "400"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Beta]", "=", "0.45"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diam", "=", "200"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "1.3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sf", "=", "0.015"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "generates", " ", "a", " ", "new", " ", "notebook", " ", 
    "with", " ", "a", " ", "report", " ", "of", " ", 
    RowBox[{"input", "/", "output"}], " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"BakerSchmidtCameraSM", "[", 
   RowBox[{"f1", ",", "\[Beta]", ",", "diam", ",", "\[Theta]", ",", "sf"}], 
   "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "prints", " ", "a", " ", "table", " ", "with", " ", "the", 
    " ", "summary", " ", "of", " ", 
    RowBox[{"input", "/", "output"}], " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"BakerSchmidtCameraSM", "[", 
   RowBox[{
   "f1", ",", "\[Beta]", ",", "diam", ",", "\[Theta]", ",", "sf", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "this", " ", "prints", " ", "a", " ", "table", " ", "with", " ", "only", 
    " ", "the", " ", "output", " ", "values"}], " ", "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"BakerSchmidtCameraSM", "[", 
   RowBox[{
   "f1", ",", "\[Beta]", ",", "diam", ",", "\[Theta]", ",", "sf", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Print\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Minimal\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{"this", " ", "gives", " ", 
     RowBox[{"input", "/", "output"}], " ", "values", " ", "as", " ", "a", 
     " ", "Return", " ", "from", " ", "the", " ", "function"}], ",", " ", 
    RowBox[{
    "with", " ", "labels", " ", "for", " ", "each", " ", "variable"}]}], " ", 
   "*)"}], "\[IndentingNewLine]", 
  RowBox[{"BakerSchmidtCameraSM", "[", 
   RowBox[{
   "f1", ",", "\[Beta]", ",", "diam", ",", "\[Theta]", ",", "sf", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Basic\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Full\>\""}]}], "]"}]}]], "Input"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "this", " ", "gives", " ", "only", " ", "output", " ", "values", " ", 
     "as", " ", "a", " ", "Return", " ", "from", " ", "the", " ", 
     "function"}], ",", " ", 
    RowBox[{"with", " ", "no", " ", "labels", " ", 
     RowBox[{"(", 
      RowBox[{
       RowBox[{
        RowBox[{"useful", " ", "for", " ", "cutting"}], "&"}], "pasting", " ",
        "operations"}], " "}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"BakerSchmidtCameraSM", "[", 
   RowBox[{
   "f1", ",", "\[Beta]", ",", "diam", ",", "\[Theta]", ",", "sf", ",", " ", 
    RowBox[{"OutputType", "\[Rule]", "\"\<Values\>\""}], ",", " ", 
    RowBox[{"OutputLevel", "\[Rule]", "\"\<Minimal\>\""}]}], "]"}]}]], "Input"],

Cell["Baker-Schmidt camera with a primary F/2, \[Beta] = 0.5.", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", "400"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Beta]", "=", "0.5"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diam", "=", "200"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "1.3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sf", "=", "0.015"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"BakerSchmidtCameraSM", "[", 
  RowBox[{"f1", ",", "\[Beta]", ",", "diam", ",", "\[Theta]", ",", "sf"}], 
  "]"}]], "Input"],

Cell["Baker-Schmidt camera with a primary F/2, \[Beta] = 0.55", "Text"],

Cell[BoxData[{
 RowBox[{
  RowBox[{"f1", "=", "400"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Beta]", "=", "0.55"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"diam", "=", "200"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"\[Theta]", "=", "1.3"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"sf", "=", "0.015"}], ";"}]}], "Input"],

Cell[BoxData[
 RowBox[{"BakerSchmidtCameraSM", "[", 
  RowBox[{"f1", ",", "\[Beta]", ",", "diam", ",", "\[Theta]", ",", "sf"}], 
  "]"}]], "Input"],

Cell["Load examples from the archive using LoadExample ", "Text"],

Cell[BoxData[
 RowBox[{"LoadExample", "[", "\"\<BakerSchmidtCameraSM\>\"", "]"}]], "Input"],

Cell[BoxData[
 RowBox[{"BakerSchmidtCameraSM", "[", "]"}]], "Input"],

Cell["Use the GUI panel to have all parameters under control", "Text"],

Cell[BoxData[
 RowBox[{"BakerSchmidtCameraSMInputPanel", "[", "]"}]], "Input"]
}, Open  ]]
},
WindowSize->{1920, 992},
WindowMargins->{{-8, Automatic}, {Automatic, -8}},
Visible->True,
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (July 28, 2016)",
StyleDefinitions->Notebook[{
   Cell[
    StyleData[StyleDefinitions -> "GeometricOptics.nb"]]}, Visible -> False, 
  FrontEndVersion -> "11.0 for Microsoft Windows (64-bit) (July 28, 2016)", 
  StyleDefinitions -> "PrivateStylesheetFormatting.nb"]
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[567, 22, 60, 0, 71, "Title"],
Cell[CellGroupData[{
Cell[652, 26, 35, 0, 43, "Subsection"],
Cell[690, 28, 115, 2, 46, "Text"],
Cell[808, 32, 1629, 43, 261, "Text"],
Cell[2440, 77, 2110, 53, 389, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4587, 135, 40, 0, 43, "Subsection"],
Cell[4630, 137, 256, 6, 46, "Text"]
}, Open  ]],
Cell[CellGroupData[{
Cell[4923, 148, 40, 0, 43, "Subsection"],
Cell[4966, 150, 111, 2, 46, "Text"],
Cell[5080, 154, 3193, 83, 551, "Text"],
Cell[8276, 239, 2296, 56, 473, "Text"],
Cell[10575, 297, 3465, 89, 849, "Text"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[14089, 392, 98, 2, 71, "Title"],
Cell[14190, 396, 260, 5, 46, "Text"],
Cell[14453, 403, 227, 4, 46, "Text"],
Cell[14683, 409, 1503, 47, 143, "Input"],
Cell[16189, 458, 41, 0, 46, "Text"],
Cell[16233, 460, 212, 6, 32, "Input"],
Cell[16448, 468, 156, 5, 32, "Input"],
Cell[16607, 475, 74, 0, 46, "Text"],
Cell[16684, 477, 508, 12, 77, "Input"],
Cell[17195, 491, 34, 0, 46, "Text"],
Cell[17232, 493, 185, 6, 32, "Input"],
Cell[17420, 501, 231, 7, 32, "Input"],
Cell[17654, 510, 46, 0, 46, "Text"],
Cell[17703, 512, 89, 2, 32, "Input"],
Cell[17795, 516, 60, 0, 46, "Text"],
Cell[17858, 518, 490, 15, 56, "Input"],
Cell[18351, 535, 68, 0, 46, "Text"],
Cell[18422, 537, 483, 17, 54, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18942, 559, 46, 0, 71, "Title"],
Cell[18991, 561, 472, 9, 94, "Text"],
Cell[19466, 572, 211, 3, 46, "Text"],
Cell[19680, 577, 372, 10, 121, "Input"],
Cell[20055, 589, 419, 10, 55, "Input"],
Cell[20477, 601, 471, 11, 55, "Input"],
Cell[20951, 614, 498, 11, 55, "Input"],
Cell[21452, 627, 648, 14, 55, "Input"],
Cell[22103, 643, 767, 18, 55, "Input"],
Cell[22873, 663, 71, 0, 46, "Text"],
Cell[22947, 665, 371, 10, 121, "Input"],
Cell[23321, 677, 147, 3, 32, "Input"],
Cell[23471, 682, 71, 0, 46, "Text"],
Cell[23545, 684, 372, 10, 121, "Input"],
Cell[23920, 696, 147, 3, 32, "Input"],
Cell[24070, 701, 65, 0, 46, "Text"],
Cell[24138, 703, 91, 1, 32, "Input"],
Cell[24232, 706, 68, 1, 32, "Input"],
Cell[24303, 709, 70, 0, 46, "Text"],
Cell[24376, 711, 78, 1, 32, "Input"]
}, Open  ]]
}
]
*)

